comment
============================================================================
    Berechnung zweistufige Wasserrakete

function wasserrakete2(pL,A11,A21,vFL1,f1,mL1,cw1,A12,A22,vFL2,f2,mL2,cw2)

mit pL=Ladedruck in Pascal
    vFL=Volumen der Flasche in m
    A1=Querschnittsflche der Flasche in m
    A2=Querschnittsflche der Dse in m
    f=Luftanteil der Flasche in p%
    mL=Leergewicht der Flasche in Kilogramm
    cw=Luftwiderstandsbeiwert

die letzte Ziffer der Variablen bezeichnet die zugehrige Stufe

============================================================================
endcomment

demodelay=180;
reset();

function delay
	global demodelay;
	return demodelay
endfunction

function warten
	wait(delay());
	return 0;
endfunction

load userfunctions

function w2(v,pL,A1,A2,vFL,f)
	return sqrt((2*pL*f^1.4*vFL^1.4/(v^1.4)-2e5)/(1000*(1-(A2/A1)^2)))
endfunction

function w2y(v,pL,A1,A2,vFL,f,a)
	return sqrt((2*pL*f^1.4*vFL^1.4/(v^1.4)-2e5)/(1000*(1-(A2/A1)^2+((1/a)-1)^2)))
endfunction


function wRLuft(wRB,cw,A1,dt,mR)
	wLuft=0;
	wrLuft=(dup(1,length(dt)))';
	for i=1 to length(dt);
		wrLuft(i)=wRB(i)-wLuft;
		dw=wrLuft(i)^2*1.293*0.5*cw*A1*dt(i)/mR(i);
		wLuft=wLuft+dw;
	end;
	return wrLuft
endfunction

function wRFLuft(wRF,cw,A1,tf,mL,dt)
	wLuft=0;
	wrLuft=(dup(1,length(tf)))';
	for i=1 to length(tf);
		wrLuft(i)=wRF(i)-wLuft;
		dw=wrLuft(i)^2*1.293*0.5*cw*A1*dt/mL;
		if wrLuft(i)>0;
			wLuft=wLuft+dw;
		else
			wLuft=wLuft-dw;
		endif;
	end;
	return wrLuft
endfunction

function taus(x,pL,A1,A2,vFL,f,a)
	return 1/(A2*w2y(x,pL,A1,A2,vFL,f,a))
endfunction

function waus(x,pL,A1,A2,vFL,f,mL,a)
	return w2y(x,pL,A1,A2,vFL,f,a)/(mL/1000+vFL-x)
endfunction

function wasserrakete2(pL,A11,A21,vFL1,f1,mL1,cw1,A12,A22,vFL2,f2,mL2,cw2)
	## Variablendefinition
	pL2=pL;
	pL1=pL;
	mLG1=mL2+(1-f2)*vFL2*1000+mL1;
	a=0.58;

	## Abgeleitete Gren
	n=1000;
	i=1:n;
	v1=vFL1*(1-f1)*i/n+f1*vFL1;
	v2=vFL2*(1-f2)*i/n+f2*vFL2;
	mR1=mLG1+(vFL1-v1)*1000;
	mR2=mL2+(vFL2-v2)*1000;

	## Ausstozeit
	"LEISTUNGSDATEN RAKETENMOTOR"
	"Brenndauer 1./2. Stufe"
	tAUS1=simpson("taus",f1*vFL1,vFL1;pL,A11,A21,vFL1,f1,a)
	tAUS2=simpson("taus",f2*vFL2,vFL2;pL2,A12,A22,vFL2,f2,a)

	tBG=tAUS1+tAUS2;
	t1=tanint("taus",f1*vFL1,vFL1,n;pL,A11,A21,vFL1,f1,a);
	t2=tanint("taus",f2*vFL2,vFL2,n;pL,A12,A22,vFL2,f2,a);
	dt1=(t1(1)|diff(t1));dt2=(t2(1)|diff(t2));

	## Endgeschwindigkeit
	""
	"Geschwindigkeiten waagerecht nach 1. und 2. Stufe"
	wAUS1=simpson("waus",f1*vFL1,vFL1;pL,A11,A21,vFL1,f1,mLG1,a)
	wAUS2=simpson("waus",f2*vFL2,vFL2;pL,A21,A22,vFL2,f2,mL2,a)+wAUS1
	wR1=tanint("waus",f1*vFL1,vFL1,n;pL,A11,A21,vFL1,f1,mLG1,a);
	wR2=tanint("waus",f2*vFL2,vFL2,n;pL,A21,A22,vFL2,f2,mL2,a)+wAUS1;

	""
	"GRAFIK Beschleunigungsphase"
	warten();
	clg;setplot(0,tBG,0,wAUS2);color(1);xplot(0,0);hold on;
	color(10);plot(t1,wR1);
	color(12);plot(tAUS1+t2,wR2);hold off;color(1);
	warten();

	"RAKETENSTART NACH OBEN"
	"Geschwindigkeit nach Brennschlu"
	wAUS2ball=wAUS2-9.81*tBG

	## Strecke und Hhe
	""
	"Erreichte Hhe"
	sR1=cumsum(dt1*wR1);
	sR2=cumsum(dt2*wR2)+sR1(1000);
	hR1=sR1-0.5*9.81*(t1^2);
	hAUS1=hR1(1000);
	hR2=sR2-0.5*9.81*(t2+tAUS1)^2;
	hAUS2=hR2(1000)
 
	## Ballistischer Flug
	tST=(wAUS2-9.81*tBG)/9.81;
	""
	"Erreichte Gesamthhe"
	hF=(wAUS2-9.81*tBG)^2/19.62+hAUS2
	tFA=sqrt(2*hF/9.81);

	tf=0:0.01:tST+tFA;
	hG=(wAUS2-9.81*tBG)*tf-0.5*9.81*tf^2+hAUS2;

	## Kombination von beschleunigtem und freiem Flug
	""
	"Gesamtzeit"
	tST+tFA+tBG
	tges=tBG+tf;

	## Beschleunigung mit Luftwiderstand gegen Erdbeschleunigung
	wRB1=wR1-9.81*t1;
	wRLuft1=wRLuft(wRB1,cw1,A11,dt1,mR1);
	hRLuft1=cumsum(dt1*wRLuft1);
	wLuftAUS1=wRLuft1(1000);
	hRLuftAUS1=hRLuft1(1000);

	wRB2=wR2-wAUS1-9.81*t2+wLuftAUS1;
	wRLuft2=wRLuft(wRB2,cw2,A12,dt2,mR2);
	""
	"Endgeschwindigkeit mit Luftwiderstand"
	wLuftAUS2=wRLuft2(1000)

	hRLuft2=cumsum(dt2*wRLuft2)+hRLuftAUS1;
	""
	"Hhe nach Brennschlu mit Luftwiderstand"
	hRLuftAUS2=hRLuft2(1000)

	## Luftwiderstand Freiflug
	wRF=wLuftAUS2-tf*9.81;
	wRLuftF=wRFLuft(wRF,cw2,A12,tf,mL2,0.01);
	hGLuft=cumsum(0.01*wRLuftF)+hRLuftAUS2;
	
	""
	"Gesamthhe mit Luftwiderstand"
	z=maxvector(hGLuft);
	z(2)

	## Kombinierte Darstellung
	""
	"GRAFIK komplettes h/t-Diagramm mit und ohne Luftwiderstand"
	warten();
	clg;setplot(0,tBG+tST+tFA,0,hF);color(1);xplot(0,0);hold on;
	color(10);plot(t1,hR1);color(2);plot(t1,hRLuft1);
	color(12);plot(t2+tAUS1,hR2);color(4);plot(t2+tAUS1,hRLuft2);
	color(1);linestyle(".");plot(tges,hG);color(8);plot(tges,hGLuft);
	linestyle("-");color(1);hold off;
	warten();
	
	return ""
endfunction

