comment
================================================
        Berechnung Wasserrakete

function wasserrakete(pL,A1,A2,vFL,f,mL,cw)

mit pL=Ladedruck in Pascal
    vFL=Volumen der Flasche in m
    A1=Querschnittsflche der Flasche in m
    A2=Querschnittsflche der Dse in m
    f=Luftanteil der Flasche in p%
    mL=Leergewicht der Flasche in Kilogramm
    cw=Luftwiderstandsbeiwert

function foptimize(pL,A1,A2,vFL,mL)
    ermittelt den Optimalwert fr f

Vorschlagswerte: pL=8e5,A1=0.012,A2=7e-5,vFL=0.001,
                 mL=0.1,cw=0.2

================================================
endcomment

demodelay=180;
reset();

function delay
	global demodelay;
	return demodelay
endfunction

function warten
	wait(delay());
	return 0;
endfunction

load userfunctions

function w2(v,pL,A1,A2,vFL,f)
	return sqrt((2*pL*f^1.4*vFL^1.4/(v^1.4)-2e5)/(1000*(1-(A2/A1)^2)))
endfunction

function w2y(v,pL,A1,A2,vFL,f,a)
	return sqrt((2*pL*f^1.4*vFL^1.4/(v^1.4)-2e5)/(1000*(1-(A2/A1)^2+((1/a)-1)^2)))
endfunction

function wRLuft(wRB,cw,A1,dt,mR)
	wLuft=0;
	wrLuft=(dup(1,length(dt)))';
	for i=1 to length(dt);
		wrLuft(i)=wRB(i)-wLuft;
		dw=wrLuft(i)^2*1.293*0.5*cw*A1*dt(i)/mR(i);
		wLuft=wLuft+dw;
	end;
	return wrLuft
endfunction

function wRFLuft(wRF,cw,A1,tf,mL,dt)
	wLuft=0;
	wrLuft=(dup(1,length(tf)))';
	for i=1 to length(tf);
		wrLuft(i)=wRF(i)-wLuft;
		dw=wrLuft(i)^2*1.293*0.5*cw*A1*dt/mL;
		if wrLuft(i)>0;
			wLuft=wLuft+dw;
		else
			wLuft=wLuft-dw;
		endif;
	end;
	return wrLuft
endfunction

function taus(x,pL,A1,A2,vFL,f,a)
	return 1/(A2*w2y(x,pL,A1,A2,vFL,f,a))
endfunction

function waus(x,pL,A1,A2,vFL,f,mL,a)
	return w2y(x,pL,A1,A2,vFL,f,a)/(mL/1000+vFL-x)
endfunction

function wasserrakete(pL,A1,A2,vFL,f,mL,cw)

	## Variablendefinition
	a=0.58;
	## Abgeleitete Gren
	n=1000;
	i=1:n;
	v=vFL*(1-f)*i/n+f*vFL;
	mR=(mL+(vFL-v)*1000);

	## Berechnung der Ausstozeit
	"LEISTUNGSDATEN RAKETENMOTOR"
	"Ausstozeit des Wassers"
	tAUS=simpson("taus",f*vFL,vFL;pL,A1,A2,vFL,f,a)
	t=tanint("taus",f*vFL,vFL,n;pL,A1,A2,vFL,f,a);
	dt=(t(1)|diff(t));

	## Wasserausstogeschwindigkeit
	""
	"GRAFIK Wasserausstogeschwindigkeit ber der Zeit [return]"
	warten();
	w2t=w2y(v,pL,A1,A2,vFL,f,a);
	xplot(t,w2t);title("w2(t) in m/s   [return]");
	warten();

	## Berechnung der Endgeschwindigkeit wAUS
	""
	"Endgeschwindigkeit der Rakete (waagerecht, ohne Luftwiderstand)"
	wAUS=simpson("waus",f*vFL,vFL;pL,A1,A2,vFL,f,mL,a)
	wR=tanint("waus",f*vFL,vFL,n;pL,A1,A2,vFL,f,mL,a);
	""
	"GRAFIK Geschwindigkeit in Abhngigkeit von der Zeit [return]"
	warten();
	xplot(t,wR);title("wR(t) in m/s   [return]");
	warten();

	## Bestimmung von Schub und Beschleunigung
	dm=vFL*(1-f)/n*1000;
	ip=w2y(v,pL,A1,A2,vFL,f,a)*dm;
	Fsch=ip/dt;
	""
	"GRAFIK Schub in N"
	warten();
	xplot(t,Fsch);title("Fsch(t) in N   [return]");
	warten();

	aR=Fsch/mR;
	""
	"GRAFIK Beschleunigung in m/s"
	warten();
	xplot(t,aR);title("a(t) in m/s   [return]");
	warten();

	""
	"RAKETENSTART NACH OBEN"
	"Geschwindigkeit nach Brennschlu"
	wAUS-9.81*tAUS

	## Bestimmung der zurckgelegten Strecke und Hhe
	sR=cumsum(dt*wR);
	hR=sR-0.5*9.81*t^2;
	""
	"Erreichte Hhe nach Brennschlu (ohne Luftwiderstand)"
	hRAUS=hR(1000)

	## Steigzeit, Fallzeit und erreichte Hhe im ballistischen Flug
	tST=(wAUS-9.81*tAUS)/9.81;
	""
	"Erreichte Gesamthhe (ohne Luftwiderstand)"
	hF=(wAUS-9.81*tAUS)^2/19.62+hRAUS
	tFA=sqrt(2*hF/9.81);
	tf=0:0.01:tST+tFA;
	hG=(wAUS-9.81*tAUS)*tf-0.5*9.81*tf^2+hRAUS;

	## Kombination von beschleunigtem und freiem Flug
	""
	"Gesamtzeit"
	tST+tFA+tAUS
	tges=tf+tAUS;

	## Luftwiderstand Beschleunigungsphase
	wRB=wR-9.81*t;
	wRBLuft=wRLuft(wRB,cw,A1,dt,mR);
	hRLuft=cumsum(dt*wRBLuft);
	""
	"Endgeschwindigkeit mit Luftwiderstand"
	wRLuftAUS=wRBLuft(1000)
	""
	"Hhe nach Brennschlu mit Luftwiderstand"
	hRLuftAUS=hRLuft(1000)

	## Luftwiderstand Freiflugphase
	wRF=wRLuftAUS-tf*9.81;
	wRLuftF=wRFLuft(wRF,cw,A1,tf,mL,0.01);
	hGLuft=cumsum(0.01*wRLuftF)+hRLuftAUS;
	z=maxvector(hGLuft);
	""
	"Gesamthhe mit Luftwiderstand"
	z(2)

	## Kombination mit Luftwiderstand
	tges=tf+tAUS;
	""
	"GRAFIK Komplettes h/t-Diagramm mit und ohne Luftwiderstand [return]"
	warten();
	clg;setplot(0,tAUS+tST+tFA,0,hF);color(1);xplot(0,0);title("Flugkurve als h/t-Diagramm  [return]");hold on;
	linestyle("-");color(10);plot(t,hR);color(2);plot(t,hRLuft);
	linestyle(".");color(1);plot(tges,hG);color(8);plot(tges,hGLuft);
	color(1);linestyle("-");hold off;
	warten();

	return ""
endfunction

function foptimize(pL,A1,A2,vFL,mL)
	n=1000;
	i=1:n;

	fvar=(0.4:0.01:0.8)';
	vfvar=vFL*(1-fvar)*i/n+fvar*vFL;
	wRf=sum(((w2(vfvar,pL,A1,A2,vFL,fvar)*vFL*(1-fvar)/n)/(mL/1000+vFL-vfvar)));
	z=maxvector(wRf);
	fvar[z(1)],z(2)
	xplot(fvar',wRf');title("wR in Abhngigkeit von f");
	return "";
endfunction
