
function diff(x)
## Erzeugt einen Vektor der Lnge length(x)-1,
## der die Differenz zwischen den Werten angibt
	a=2:length(x);
	return x[a]-x[a-1]
endfunction

function tanint(ffunction,a,b,n)
## Berechnet das Integral von ffunction in [a,b]
## nach der Tangentenmethode, das Ergebnis wird als
## n langer Vektor ausgegeben
	h=(b-a)/(2*n);
	xo=h:2*h:2*n*h;
	x=xo+a;
	if isfunction(ffunction);
		s=ffunction(x,args());
	else
		s=expreval(ffunction,x);
	endif;
	integral=2*h*cumsum(s);
	return integral
endfunction

function maxvector(vect)
## Erzeugt einen 1x2 Vektor mit dem Maximalwert
## des Vektors und der zugehrigen Stelle
	xmax=1;ymax=vect(1);
	for i=2 to length(vect);
	if vect(i)>ymax;
		xmax=i;ymax=vect(i);
	endif;
	end;
	ergebnis=[xmax,ymax];
	return ergebnis
endfunction

function singrad(x)
## Berechnet die Sinusfunktion eines Winkels in Grad
	return sin(x*2*pi/360)
endfunction

function cosgrad(x)
## Berechnet die Cosinusfunktion eines Winkels in Grad
	return cos(x*2*pi/360)
endfunction

function tangrad(x)
## Berechnet die Tangensfunktion eines Winkels in Grad
	return tan(x*2*pi/360)
endfunction

function asingrad(x)
## Berechnet den Winkel in Grad einer Sinusfunktion
	return asin(x)*360/(2*pi)
endfunction

function acosgrad(x)
## Berechnet den Winkel in Grad einer Cosinusfunktion
	return acos(x)*360/(2*pi)
endfunction

function atangrad(x)
## Berechnet den Winkel in Grad einer Tangensfunktion
	return atan(x)*360/(2*pi)
endfunction
